unit AddFilesFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, RzBorder, RzButton, StdCtrls, Mask, RzEdit, RzLstBox, RzLabel,
  RzShellDialogs;

type
  TAddFilesForm = class(TForm)
    RzLabel10: TRzLabel;
    FilesList: TRzListBox;
    RzLabel9: TRzLabel;
    editFile: TRzEdit;
    btnAddFile: TRzButton;
    btnRemoveFile: TRzBitBtn;
    btnOK: TRzButton;
    RzBorder1: TRzBorder;
    btnSelectFile: TRzBitBtn;
    btnCancel: TRzButton;
    OpenDialog: TRzOpenDialog;
    procedure btnAddFileClick(Sender: TObject);
    procedure btnRemoveFileClick(Sender: TObject);
    procedure btnSelectFileClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure PrepareList(S: String);
  end;

const
  ContentFileFilter = 'All documents (*.DOC, *.TXT, *.RTF)|*.doc;*.txt;*.rtf';

var
  AddFilesForm: TAddFilesForm;

implementation

{$R *.dfm}

procedure TAddFilesForm.btnAddFileClick(Sender: TObject);
begin
  if Trim(editFile.Text) <> '' then
   FilesList.Items.Add(editFile.Text);
end;

procedure TAddFilesForm.btnRemoveFileClick(Sender: TObject);
begin
  if FilesList.ItemIndex > -1 then
   FilesList.Items.Delete(FilesList.ItemIndex);
end;

procedure TAddFilesForm.PrepareList(S: String);
begin
  FilesList.Items.Clear;
  while Pos('|', S) > 0 do
  begin
    if Trim(Copy(S, 1, Pos('|', S)-1)) <> '' then
     FilesList.Items.Add(Copy(S, 1, Pos('|', S)-1));
    Delete(S, 1, Pos('|', S));
  end;
  if S<>'' then
   FilesList.Items.Add(S);
end;

procedure TAddFilesForm.btnSelectFileClick(Sender: TObject);
begin
  OpenDialog.Filter := ContentFileFilter;
  OpenDialog.InitialDir := ExtractFilePath(ParamStr(0));
  if OpenDialog.Execute then
    editFile.Text := OpenDialog.FileName;
end;

procedure TAddFilesForm.FormCreate(Sender: TObject);
begin
  FilesList.Clear;
end;

end.
